
;


/*
 * waitForImages 1.3.2
 * -----------------
 * Provides a callback when all images have loaded in your given selector.
 * http://www.alexanderdickson.com/
 *
 *
 * Copyright (c) 2011 Alex Dickson
 * Licensed under the MIT licenses.
 * See website for more info.
 *
 */

;(function($) {
    
    // CSS properties which contain references to images. 
    $.waitForImages = {
        hasImageProperties: [
        'backgroundImage',
        'listStyleImage',
        'borderImage',
        'borderCornerImage'
        ]
    };
    
    // Custom selector to find `img` elements that have a valid `src` attribute and have not already loaded.
    $.expr[':'].uncached = function(obj) {
        return $(obj).is('img[src!=""]') && ! obj.complete; 
    };
    
    $.fn.waitForImages = function(finishedCallback, eachCallback, waitForAll) {

        // Handle options object.
//        if ($.isPlainObject(arguments[0])) {
//            eachCallback = finishedCallback.each;
//            waitForAll = finishedCallback.waitForAll;
//            finishedCallback = finishedCallback.finished;
//        }

        // Handle missing callbacks.
        finishedCallback = finishedCallback || $.noop;
        eachCallback = eachCallback || null;

        // Convert waitForAll to Boolean
        waitForAll = !! waitForAll;

        // Ensure callbacks are functions.
        if (!$.isFunction(finishedCallback)) {
            throw new TypeError('An invalid callback was supplied.');
        };

        return this.each(function() {
            // Build a list of all imgs, dependent on what images will be considered.
            var obj = $(this),
                allImgs = [];

            if (waitForAll) {
                // CSS properties which may contain an image.
                var hasImgProperties = $.waitForImages.hasImageProperties || [],
                    matchUrl = /url\((['"]?)(.*?)\1\)/g;
                
                // Get all elements, as any one of them could have a background image.
                obj.find('*').each(function() {
                    var element = $(this);

                    // If an `img` element, add it. But keep iterating in case it has a background image too.
                    if (element.is('img:uncached')) {
                        allImgs.push({
                            src: element.attr('src'),
                            element: element[0]
                        });
                    }

                    $.each(hasImgProperties, function(i, property) {
                        var propertyValue = element.css(property);
                        // If it doesn't contain this property, skip.
                        if ( ! propertyValue) {
                            return true;
                        }

                        // Get all url() of this element.
                        var match;
                        while (match = matchUrl.exec(propertyValue)) {
                            allImgs.push({
                                src: match[2],
                                element: element[0]
                            });
                        };
                    });
                });
            } else {
                // For images only, the task is simpler.
                obj
                 .find('img:uncached')
                 .each(function() {
                    allImgs.push({
                        src: this.src,
                        element: this
                    });
                });
            };

            var allImgsLength = allImgs.length,
                allImgsLoaded = 0;

            // If no images found, don't bother.
            if (allImgsLength == 0) {
                finishedCallback.call(obj[0]);
            };

            $.each(allImgs, function(i, img) {
                
                var image = new Image;
                
                // Handle the image loading and error with the same callback.
                $(image).bind('load error', function(event) {
                    allImgsLoaded++;
                    
                    // If an error occurred with loading the image, set the third argument accordingly.
                    if (eachCallback){
                        eachCallback.call(img.element, allImgsLoaded, allImgsLength, event.type == 'load');
                    }
                    
                    if (allImgsLoaded == allImgsLength) {
                        finishedCallback.call(obj[0]);
                        return false;
                    };
                    
                });

                image.src = img.src;
            });
        });
    };
})(jQuery);
;


﻿//var camilyo = { };
var $mainContent;
var transitions;

$(document).ready(function () {
    // init members
    $mainContent = $('#Content');
    if ($mainContent.length == 0) {
        $mainContent = $('.Content_wp_outer').filter(":visible");
    }
    // init multi-level menu item events
    $('.mlhmenu').mouseenter(function () {
        $(this).parents('.wp_first_col').not('[class*="MainColumns"]').css('overflow', 'visible');
    })
    .mouseleave(function () {
        $(this).parents('.wp_first_col').not('[class*="MainColumns"]').css('overflow', 'hidden');
    });
    // bind resize evet
    $(window).resize(onWindowResize);
    // do layout
    if (typeof (window.initLayout) == 'function') {
        initLayout();
    }
    // after images are loaded
    $('#msgwebcontainer').waitForImages(function () {
        // init sticky panels
        if (window.initStickyPanels) {
            initStickyPanels();
        }
    });
    // init transition
    if (transitions) {
        initTransitions();
    }

    //prevent google ma from loading roboto font
    var head = document.getElementsByTagName('head')[0];
    // Save the original method
    var insertBefore = head.insertBefore;
    // Replace it!
    head.insertBefore = function (newElement, referenceElement) { 
        if (newElement.href && newElement.href.indexOf('//fonts.googleapis.com/css?family=Roboto') > -1) {
            console.info('Prevented GM from loading Roboto !');
            return;
        }
        insertBefore.call(head, newElement, referenceElement);
    };
});

function onWindowResize() {
    fixLayoutOnWindowResize();
}

function GetUrlParameters(name) {
    name = name.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
    var regexS = "[\\?&]" + name + "=([^&#]*)";
    var regex = new RegExp(regexS);
    var results = regex.exec(window.location.href);
    if (results == null) {
        return "";
    } else {
        return results[1];
    }
}

$.fn.scrollView = function (iDelay) {
    return this.each(function () {
        $('html, body').animate({
            scrollTop: $(this).offset().top
        }, iDelay);
    });
}

function jumpTo(id) {
    if (id.indexOf('#') != 0) {
        id = '#' + id;
    }
    var $form = $(id);
    if (!isElementInViewport($form)) {
        $form.scrollView(800);
    }
}

function isElementInViewport(el) {

    //special bonus for those using jQuery
    if (el instanceof jQuery) {
        el = el[0];
    }

    var rect = el.getBoundingClientRect();

    return (
        rect.top >= 0 &&
        rect.left >= 0 &&
        rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) && /*or $(window).height() */
        rect.right <= (window.innerWidth || document.documentElement.clientWidth) /*or $(window).width() */
    );
}


/*
if (!Array.prototype.indexOf) {
    Array.prototype.indexOf = function (obj, start) {
        for (var i = (start || 0), j = this.length; i < j; i++) {
            if (this[i] === obj) { return i; }
        }
        return -1;
    }
}*/
;


﻿var sShowIconUrl = '/web/handlers/ImageGalleryHandler.ashx' + "?action=showicon&img=";
var sShowImageUrl = '/web/handlers/ImageGalleryHandler.ashx' + "?action=showimage&img=";
var resultOfPageJs;
var holderMode = true;
var isTransitioning = false;
var blogNewOrd;
var isBlogTransition;
var isInnerBlogPage;
var ms_cssFiles = {};

function initTransitions() {
    $('#msgwebcontainer').find('[page][page!=' + transitions.currPageOrd + '][page!=' + transitions.pages[transitions.currPageOrd].masterOrd + ']').waitForImages(function () {
        $(this).hide().css('z-index', '');
    });
    $('body').append('<div class="transition_modal"><img src="/static-images/mobeepreview/msgloading.gif"></div>');
    $('.transition_modal').hide();
    var data = { pageOrd: transitions.currPageOrd, href: transitions.pages[transitions.currPageOrd].title };
    if (history.replaceState) {
    history.replaceState(data, transitions.pages[transitions.currPageOrd].friendlyTitle, window.location.href);
    }
    window.addEventListener('popstate', function (event) {
        if (event.state) {
            doTransition(event.state.pageOrd, null, (event.state.href));
        }
    });
}

function doTransition(pageOrd, menuItem, href) {
   
    //check if the previous transition is already finished, othewise do nothing.
    if (isTransitioning) {
        return false;
    } else {
        isTransitioning = true;
    }
    var currConf = transitions.pages[transitions.currPageOrd];
    var newConf = transitions.pages[pageOrd];
    var fullPageUrl = window.location.href;

    //special hendling in case of blog
    checkForBlogInnerUrl(currConf, fullPageUrl);
    var blogUrl = setIsInsideBlogTransition(menuItem, fullPageUrl);

    //in case we try to go to the same page
    if (!checkIfSamePage(pageOrd, menuItem)) {
        return false;
    };
    //background transitions adjusment
    $('body').find('[class*="wp_outer"]').removeClass('background-image-change');
  
    //more blog handeling
    if (isInnerBlogPage) {
        if (menuItem == null) {
            newConf = updateNewConf(currConf, newConf, fullPageUrl, menuItem);
        } else {
            currConf = updateNewConf(currConf, newConf, fullPageUrl, menuItem);
        }
    }
    if (isBlogTransition) {
        newConf = getNewConfForBlogPage(newConf, menuItem);
    }

    //backword competibility
    if ($('#MiddleExternal').length > 0 && currConf.masterOrd != newConf.masterOrd) {
        isTransitioning = false;
        if (!($(menuItem).attr('href'))) {
            window.open(newConf.title, '_self');
        }
        return true;
    }
    //in case it the first transition we need to wrap the page
    handleFirstPage(currConf);

    //check if need a master page change, and if so do preperations for the change 
    var changeMaster =  masterPageChangeHandaling(currConf, newConf);
    var currPage = $('#page' + currConf.pageOrd);

    //change browser url to the new page
    handleBrowserUrlAndPageName(newConf, menuItem, blogUrl);

    //side panel close 
    if ($.pageslide) {
        $.pageslide.close();
    }

    if (!menuItem) {
        menuItem = $('a[onclick*="doTransition(' + newConf.pageOrd + ',"]')[0];
    }

    //handle menu class .._selected so the right menu item will be show as selected
    handleMenuSelected(currConf, newConf, changeMaster, menuItem);
    var url = getUrlForAjax(menuItem, blogUrl, newConf, href);

    //case where the page is already inside the dom
    if ($('#page' + newConf.pageOrd).length > 0) {
        makeTransition(currPage, $('#page' + newConf.pageOrd), changeMaster, newConf.masterOrd, currConf.masterOrd, function () {
            var shref = $(menuItem).attr('href');
            if (typeof (window.msgExpand) == 'function') {
                msgExpand();
            }
            initStickyPanels();
            scrollToElem(shref);
            isTransitioning = false;
        });
        transitions.currPageOrd = isBlogTransition ? blogNewOrd : pageOrd;
        $.get(removeBad(url) + '?dontRender=true');
        return false;
    }

    //page is already fetched and is stored in a js global var
    if (window.premptivePages && window.premptivePages[newConf.pageOrd]) {
        doExtualTransition(premptivePages[newConf.pageOrd], currConf, newConf, menuItem, changeMaster);
        //$('.transition_modal').hide();
    } else {
        var transitionOpt;
        if (changeMaster) {
            transitionOpt = { 'isFullTransition': true };
        } else {
            transitionOpt = { 'isTransition': true };
        }
        $('.transition_modal').show();
        var options =
        {
            type: "GET",
            url: url,
            data: transitionOpt,
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            async: true,
            success: function(response) {
                doExtualTransition(response, currConf, newConf, menuItem, changeMaster);
                //$('.transition_modal').hide();
            },
            error: function(response) {
                isTransitioning = false;
            }
        };
        jQuery.ajax(options);
    }
    transitions.currPageOrd = isBlogTransition ? blogNewOrd : pageOrd;
    return false;
}


function addOrUpdateStyleTagForTransitions(res, contentStr, currConf, newConf, changeMaster, menuItem) {
    var runTransitionsFunc = false;
    //checking the styles tags we get with the new page
    for (var i = 0; i <res.Css.length; i++) {
        var $styleTag = $(res.Css[i]);
        if ($('head').find('[id^="camilyo_palettes"]').length > 0) {
            //removing old master page style tag and adding the one
            if ($styleTag.attr('id').indexOf('camilyo_mp') == 0) {
                if (!changeMaster) {
                    continue;
                } else {
                    var mp_css = $('head').find('[id^="camilyo_mp"]');
                    $('head').append($styleTag);
                    setTimeout(function() {
                        mp_css.remove();
                    }, 4500);
                    continue;
                }
            }
            if ($styleTag.attr('id') == "camilyo_palettes") {
                continue;
            }
            //adding new style tag for the new page
            if ($styleTag.attr('id').indexOf('camilyo_page') == 0) {
                var url = $styleTag.attr('href');
                runTransitionsFunc = true;
                $.get(url, function (data) {
                    //$('<style rel="stylesheet" type="text/css">' + data + '</style>').prependTo($('head'));
                    $styleTag.prependTo($('head'));
                    setTimeout(function () {
                        addScriptsAndMakeTransition(res, contentStr, currConf, newConf, changeMaster, menuItem);
                        $('.transition_modal').hide();
                    }, 20);
                });
                continue;
            }
        }
        var styleVal = $styleTag.html();
        styleVal = styleVal.replace("<![CDATA[", "").replace("]]>", "");
        styleVal = styleVal.replace("mg://", sShowImageUrl);
        if (changeMaster) {
            styleVal = styleVal.replace(/.msgwebcontainer/g, "#masterpage_" + newConf.masterOrd);
        }
        styleVal = styleVal.replace("ig://", sShowIconUrl);
        $styleTag.html(styleVal);
        $styleTag.prependTo($('head'));
        
    }
    if (!runTransitionsFunc) {
        addScriptsAndMakeTransition(res, contentStr, currConf, newConf, changeMaster, menuItem);
        $('.transition_modal').hide();
    }
}

function makeTransition(oldPage, newPage, changeMaster, toMaster, fromMaster, callback) {
    // do content transition according to type
    switch (transitions.type) {
        case 'Fade':
            if (changeMaster || toMaster != fromMaster) {
                doTransitionFull(oldPage, newPage, toMaster, fromMaster, "fade", callback);
            }
            else { doFadeTransition(oldPage, newPage, toMaster, callback); }

            break;
        case 'Push':
            if (changeMaster || toMaster != fromMaster) {
                doTransitionFull(oldPage, newPage, toMaster, fromMaster, "push", callback);
            } else {
                doPushTransition(oldPage, newPage, toMaster, callback);
            }
            break;
    }
}


function scrollToElem(shref) {
    if (shref) {
        var startPoint = shref.indexOf('#') + 1;
        if (startPoint > 0) {
            var sAnchor = shref.substring(startPoint, shref.length);
            var $elem = $('[name = "' + sAnchor + '"]');
            if ($elem.length == 0) {
                $elem = $('#' + sAnchor);
            }
            if ($elem.length > 0) {
                var hash = '#' + sAnchor;
                doSmoothScroll($elem, camilyo.inPageTime, hash);
            } 
        }
        else {
            setTimeout(function () {
                window.scrollTo(0, 0);
            }, 1);
        }
    } 
}

function setIsInsideBlogTransition(menuItem, fullPageUrl) {
    isBlogTransition = $(menuItem) && $(menuItem).attr('name') && $(menuItem).attr('href') &&
     ($(menuItem).attr('name').indexOf('article_') > -1 || $(menuItem).attr('name').indexOf('blog') > -1) &&
     ($(menuItem).attr('href').indexOf('/articles/') > -1 || $(menuItem).attr('href').indexOf('?articleId=')) > -1;
    var blogUrl='';
    if (isBlogTransition) {
        if ($(menuItem).attr('href').indexOf('articleId=') > -1) {
            blogUrl = fullPageUrl + $(menuItem).attr('href');
        } else {
            blogUrl = "//" + window.location.host + '/' + $(menuItem).attr('href');
        }
    }
    return blogUrl;
}

function updateNewConf(currConf,newConf, fullPageUrl, menuItem) {
    var suffixId ="";
    if (fullPageUrl.indexOf('?month') > -1) {
        suffixId = 'month';
    }
    if (fullPageUrl.indexOf('?tagname') > -1) {
        suffixId = 'tagname';
    }
    if (fullPageUrl.indexOf('?articlesId') > -1 || fullPageUrl.indexOf('/articles/') > -1) {
        suffixId = 'article';
    }
    var newId = (menuItem?newConf.pageOrd:currConf.pageOrd) + '_' + suffixId;
    if (!transitions.pages[newId]) {
        transitions.pages[newId] = {
            pageOrd: newId,
            masterOrd: menuItem ? newConf.masterOrd : currConf.masterOrd,
            friendlyTitle: menuItem ? newConf.friendlyTitle : currConf.friendlyTitle,
            title: menuItem ? newConf.title : currConf.title
        };
    }
    return transitions.pages[newId];
}

function removeBad(url) {
    var startPoint = url.indexOf('#');
    if (startPoint > 0) {
        return url.substring(0, startPoint - 1);
    }
    return url;

}

function doExtualTransition(res, currConf, newConf, menuItem, changeMaster) {
    var contentStr;
    //case where master page is changing
    if (changeMaster) {
        //insert the whole new master page html as one of the pages inside content temporaly
        var page = $(res.Html).filter("#msgwebcontainer").html();
        contentStr = '#msp' + currConf.masterOrd + '_Content';
        $(contentStr).append('<div id = "page' + newConf.pageOrd + '" class="full" style="display:none">' + page + '</div>');
    } else {
        contentStr = '#msp' + newConf.masterOrd + '_Content';
        //extract content html
        var $content = $(res.Html).find(contentStr).length > 0 ? $(res.Html).find(contentStr) : $(res.Html).filter(contentStr);
        if ($content.length == 0) {
            $content = $(res.Html).find('#Content').length > 0 ? $(res.Html).find('#Content') : $(res.Html).filter('#Content');
            contentStr = "#Content";
        }
        //handles contentTop and contentBottom, move them out of the content
        var ct = $content.find(contentStr + 'Top');
        if (ct.length>0) {
            $(contentStr + 'Top').html(ct.html());
        }
        var cb = $content.find(contentStr + 'Bottom');
        if (cb.length > 0) {
            $(contentStr + 'Bottom').html(cb.html());
        }
        $content.find(contentStr + 'Top').remove();
        $content.find(contentStr + 'Bottom').remove();
        var content = $content.html();
        //appent new page content in a page div insite the curr master page content
        $(contentStr).append('<div id = "page' + newConf.pageOrd +  '" style="display:none">' + content + '</div>');
    }
    addOrUpdateStyleTagForTransitions(res, contentStr, currConf, newConf, changeMaster, menuItem);
}


function rebindMenuEvents(page) {
    $(page).find('.mlhmenu').mouseenter(function () {
        $(this).parents('.wp_first_col').not('[class*="MainColumns"]').css('overflow', 'visible');
    })
       .mouseleave(function () {
           $(this).parents('.wp_first_col').not('[class*="MainColumns"]').css('overflow', 'hidden');
       });
}

function addScriptsAndMakeTransition(res, contentStr, currConf, newConf, changeMaster, menuItem) {
    resultOfPageJs = res.JsCode;
    //add external scripts to dom
    addScriptTags(res.JsCode, false);
    if (window.WOW) {
        var wow = new WOW().init();
    }
    $(contentStr).waitForImages(function () {
        makeTransition($('#page' + currConf.pageOrd), $('#page' + newConf.pageOrd), changeMaster, newConf.masterOrd, currConf.masterOrd, function() {
            if (addScriptTags(res.JsCode, true)) {
                //add all the other scripts to dom
                addRestOfScripts(res.JsCode);
            };

            if (window.FB) {
                FB.XFBML.parse();
            }
            var updatedTitle = window['transitions_current_page_seo_title_' + newConf.pageOrd.split('_')[0]];
           
            //change page title, acts different in case of blog
            var seoTitle = window.transitions.pages[newConf.pageOrd.split('_')[0]].seoTitle;
            if (seoTitle.indexOf("[[blog:") == 0 && updatedTitle) {
                    window.transitions.pages[newConf.pageOrd].friendlyTitleCurrent = updatedTitle;
                    $(document).prop('title', updatedTitle);
            }
            if (updatedTitle) {
                updatedTitle = updatedTitle.replace(/&amp;/g, '&');
            }
            $(document).prop('title', updatedTitle);
            
        


            if (typeof (backgroundGalleryTransitions) == 'function') {
                backgroundGalleryTransitions(true);
            }
            if (!holderMode) {
                $('#page' + currConf.pageOrd).remove();
            }
            var shref = $(menuItem).attr('href');
            setTimeout(function () { scrollToElem(shref); }, 50);
            //scrollToElem(shref);
            if (typeof (InitShop) == 'function') {
                InitShop();
            }
            if (typeof (window.msgExpand) == 'function') {
                msgExpand();
            }
            initStickyPanels();
            isTransitioning = false;
        });
    });
}

function doPushTransition(oldPage, newPage, masterPage, callback) {
    // set body overflow-x to hidden to avoid horizontal scroll during the effect
    var contentStrt = '#msp' + masterPage + '_Content';
    if ($(contentStrt).length == 0) {
        contentStrt = "#Content";
    }
    $('body').css('overflow-x', 'hidden');
    // set main content height so footer will not hide the content
    var newPageHeight = getNextPageContentHeight(newPage);
    var currHeight = oldPage.height();
    // get the bigger one
    var contentHeight = newPageHeight > currHeight ? newPageHeight : currHeight;
    $(contentStrt).css('height', contentHeight);
    // start animation
    newPage.stop(true, true);
    oldPage.stop(true, true);
    var width = $(contentStrt).width();
    var windowWidth = $(window).width();
    var left = oldPage.offset().left;
    oldPage.css({ position: 'absolute', left: 0, width: width });
    newPage.css({ position: 'absolute', left: windowWidth, width: width, }).show();

    oldPage.animate({ left: 0 - windowWidth }, 1000, function () {
        oldPage.hide();
        oldPage.css({ position: '', left: '', top: '', width: '' });
        if (!holderMode) {
            oldPage.remove();
        }
    });
    newPage.animate({ left: 0 }, 1000, function () {
        newPage.css({ position: '', left: '', top: '', width: '' });
        // remove css used for effect
        $(contentStrt).css({ height: '', 'overflow-x': '' });
        if (callback) {
            callback();
        }
    });
}

function doFadeTransition(oldPage, newPage, masterId, callback) {
    var str = '#msp' + masterId;
    var dif = getNextPageContentHeight(newPage) - oldPage.height();
    var $footer = $(str + '_FooterExternal');
    if ($footer.length == 0) {
        $footer = $('#FooterExternal');
    }
    if ($footer.length > 0) {
        if ($footer.css('position') != 'fixed') {
            $footer.css('position', 'relative');
            $footer.animate({ 'top': dif }, 750, function () {
                $footer.css('top', '');
                $footer.css('position', '');
            });
        }
    }
    newPage.stop(true, true);
    oldPage.stop(true, true).fadeOut(750, function () {
        newPage.fadeIn(750, callback);
    });
}

function doTransitionFull(oldPage, newPage, toMaster, fromMaster, type, callback) {
    //case where there is a need to change master page
    //get ids for each mp content
    var contentStrf = '#msp' + fromMaster + '_Content';
    var contentStrt = '#msp' + toMaster + '_Content';

    $('body').css('overflow-x', 'hidden');

    //if mp(master page) div already exist
    if ($('#masterpage_' + toMaster).length > 0) {
        var oldMaster = $('#masterpage_' + fromMaster);
        var newMaster = $('#masterpage_' + toMaster);
        newMaster.show();
        newPage.show();
        if (typeof (window.msgExpand) == 'function') {
            msgExpand();
        }
        newMaster.hide();
        if (type == "fade") {
            oldMaster.stop(true, true).fadeOut(750, function () {
                oldPage.hide();
                if (oldMaster.find(newPage).length > 0) {
                    $(contentStrt).append(newPage);
                    oldMaster.find('#page' + newPage.attr("id")).remove();
                }
                newMaster.fadeIn(750, callback);
            });
        } else {
            doPushAnimation(newMaster, oldMaster, oldPage, newPage, callback);
        }

    //first browse to the new mp, needs to build the stracture
    } else {
        newPage.show();
        if (typeof (window.msgExpand) == 'function') {
            msgExpand();
        }
        newPage.hide();
        if (type == "fade") {
            $('#msgwebcontainer').stop(true, true).fadeOut(750, function () {
                oldPage.hide();
                newMasterBoxPrepare(oldPage, newPage, toMaster, fromMaster, contentStrf, contentStrt, "fade");
                $('#msgwebcontainer').fadeIn(750, callback);
            });
        }
        else {
            newMasterBoxPrepare(oldPage, newPage, toMaster, fromMaster, contentStrf, contentStrt, "push");
            oldMaster = $('#masterpage_' + fromMaster);
            newMaster = $('#masterpage_' + toMaster);
            doPushAnimation(newMaster, oldMaster, oldPage, newPage, callback);
        }
    }
}


function doPushAnimation(newMaster, oldMaster, oldPage, newPage, callback) {
    var windowWidth = $(window).width();
    newMaster.parent().css('height', '100%');
    newMaster.css({ position: 'absolute', top: 0, left: windowWidth, width: windowWidth, }).show();
    oldMaster.css({ position: 'absolute', top: 0, left: 0, width: windowWidth });
    newPage.show();
    oldMaster.animate({ left: 0 - windowWidth }, 1000, function () {
        oldPage.hide();
        oldMaster.hide();
        oldMaster.css({ position: '', left: '', top: '', width: '' });
    });
    newMaster.animate({ left: 0 }, 1000, function () {
        newMaster.css({ position: '', left: '', top: '', width: '' });
        newMaster.parent().css('height', '');
        if (callback) {
            callback();
        }
    });
}


//prapere 2 master pages div that will contain their pages
function newMasterBoxPrepare(oldPage, newPage, toMaster, fromMaster, contentStrf, contentStrt, type) {
    var oldMasterPage;
    var rebindOld = false;
    
    if ($('#masterpage_' + fromMaster).length > 0) {
        oldMasterPage = $('#masterpage_' + fromMaster);
    } else {
      //add old mp page div if it is not exist
        oldMasterPage = $('#msgwebcontainer').children().wrapAll("<div id='masterpage_" + fromMaster + "'></div>").parent();
        $('#msgwebcontainer').children().remove();
        rebindOld = true;
    }
    //adding the new full page the the new mp div
    var newMasterPage = newPage.children().wrapAll("<div id='masterpage_" + toMaster + "'></div>").parent();
    //insert the master pages to msgwebcontainer
    $('#msgwebcontainer').append(newMasterPage);
    $('#msgwebcontainer').append(oldMasterPage);
    if (rebindOld) {
        rebindMenuEvents('#masterpage_' + fromMaster);
    }
    if (type == "fade") {
        oldMasterPage.hide();
        $(contentStrf).children().filter('[class*="page"]').hide();
    } else {
        newMasterPage.hide();
    }
    //remove the new full page from old master page, and wrap the content div inside new mp in a page div
    $(contentStrt).wrapInner("<div id='" + newPage.attr('id') + "'></div>");
    oldMasterPage.find(contentStrf + " #" + newPage.attr('id')).remove();
    rebindMenuEvents('#masterpage_' + toMaster);
}

function getNextPageContentHeight(newPage) {
    newPage.css({ 'z-index': -10000 }).show();
    var contentHeight = newPage.height();
    if (typeof (window.msgExpand) == 'function') {
        msgExpand();
    }
    newPage.hide().css({ 'z-index': 0 });
    return contentHeight;
}

function addCode() {
    addRestOfScripts(resultOfPageJs);
}

function addRestOfScripts(js) {
    var sCode = '';
    if (js.Classes) {
        for (var sClassId in js.Classes) {
            var $script = $('head #' + sClassId);
            if ($script.length == 0) {
                sCode += js.Classes[sClassId];
            }
        }
    }
    if (js.Vars) {
        js.Vars = js.Vars.replace("this.wow = new WOW().init()", '');
        js.Vars = js.Vars.replace(/\\/g, '');
        sCode += js.Vars;
    }
    if (js.InitCode) {
        sCode += js.InitCode;
    }

    if (js.External['msgjsext_swapHandler'] && typeof (swapOnLoad) == 'function') {
        swapOnLoad();
    }
    if (js.External['msgjsext_tabsHandler'] && typeof (tabshandlerOnLoad) == 'function') {
        tabshandlerOnLoad();
    }

    var textArea = $('.msgwebcontainer textarea');
    for (var i = 0; i < textArea.length; i++) {
        if (!$(textArea[i]).attr('defaultvalue')) {
            $(textArea[i]).val('');
        }
    }
    eval.call(window,sCode);
}

function addScriptTags(js, handleMap) {
    if (js.External) {
        var hasMap = false;
        for (var sExtId in js.External) {
            var $extscript = $('head #' + sExtId);
            if ($extscript.length == 0) {
                var s = document.createElement("script");
                s.type = "text/javascript";
                if ($('head').find('#' + sExtId).length > 0) {
                    continue;
                }
                if (sExtId == 'msgjsext_lightbox' && $('#lightbox').length > 0) {
                    continue;
                }
                if ((sExtId == 'msgjsext_googleMapJS' || sExtId == 'msgjsext_atlasctMapJS') && !handleMap) {
                    continue;
                }
                if (sExtId == 'msgjsext_lightboxscript' && $('#lightbox').length > 0) {
                    continue;
                }
                if ((sExtId == 'msgjsext_googleMapJS' || sExtId == 'msgjsext_atlasctMapJS')) {
                    if (sExtId == 'msgjsext_atlasctMapJS') {
                        s.src = js.External[sExtId];
                    } else {
                        if ($('#msgjsext_googleMapJS').length > 0) {
                            continue;
                        }
                        s.src = js.External[sExtId] + '&callback=addCode';
                    }
                    hasMap = true;
                } else {
                    s.src = js.External[sExtId];
                }
                if (handleMap && (sExtId != 'msgjsext_googleMapJS' && sExtId != 'msgjsext_atlasctMapJS')) {
                    continue;
                }
                if (sExtId == 'msgjsext_interact') {
                    $('head').append('<link href="' + s.src.replace('interact.js', 'interact.css') + '" type="text/css" rel="stylesheet">');
                }
                // Use any selector
                $("head").append(s);
            }
        }
        if (hasMap) {
            return false;
        }
    }

    return true;
}

function checkForBlogInnerUrl(currConf, fullPageUrl) {
    if ($('#page' + currConf.pageOrd).length == 0) {
        if (fullPageUrl.indexOf('?month=') > -1 || fullPageUrl.indexOf('?articleId=') > -1 || fullPageUrl.indexOf('?tagname=') > -1 || fullPageUrl.indexOf('/articles/') > -1) {
            isInnerBlogPage = true;
        } else {
            isInnerBlogPage = false;
        }
    } else {
        isInnerBlogPage = false;

    }
}

function checkIfSamePage(pageOrd, menuItem) {
    if (pageOrd == transitions.currPageOrd && !isBlogTransition && !isInnerBlogPage) {
        var nhref = $(menuItem).attr('href');
        if ($.pageslide) {
            $.pageslide.close();
        }
        scrollToElem(nhref);
        isTransitioning = false;
        return false;
    } else {
        isTransitioning = true;
        return true;
    }
}

function getNewConfForBlogPage(newConf, menuItem) {
    blogNewOrd = newConf.pageOrd + '_' + $(menuItem).attr('name').replace('article_', '');
    if (!transitions.pages[blogNewOrd]) {
        transitions.pages[blogNewOrd] = {
            pageOrd: blogNewOrd,
            masterOrd: newConf.masterOrd,
            friendlyTitle: newConf.friendlyTitle,
            title: newConf.title
        };
    }
    return transitions.pages[blogNewOrd];
}

function handleFirstPage(currConf) {
    var contentStr = '#msp' + currConf.masterOrd + '_Content';
    if ($('#page' + currConf.pageOrd).length == 0) {
        if ($(contentStr).length == 0) {
            contentStr = '#Content';
        }
        $(contentStr).wrapInner('<div id = "page' + currConf.pageOrd + '">');
    }
    if ($(contentStr).find(contentStr + 'Top').length > 0 || $(contentStr).find(contentStr + 'Bottom').length > 0) {
        $(contentStr).prepend($(contentStr + 'Top')).prepend($(contentStr + 'Bottom'));
    }
}


function masterPageChangeHandaling(currConf,newConf) {
    var changeMaster = false;
    if (currConf.masterOrd != newConf.masterOrd && !isBlogTransition) {
        ms_cssFiles['mp_' + currConf.masterOrd] = $('[id="camilyo_mp_' + currConf.masterOrd + '"]').attr('href');
        if ($('#masterpage_' + newConf.masterOrd).length == 0) {
            changeMaster = true;
        } else {
            if ($('head').find('[id^="camilyo_palettes"]').length > 0) {
                var mp_css = $('[id="camilyo_mp_' + currConf.masterOrd + '"]');
                var $cssNew = document.createElement('link');
                $cssNew.href = ms_cssFiles['mp_' + newConf.masterOrd];
                $cssNew.id = 'camilyo_mp_' + newConf.masterOrd;
                $cssNew.rel = 'stylesheet';
                $cssNew.type = 'text/css';
                //$($cssNew).prependTo($('head'));
                $('head').append($cssNew);
                setTimeout(function () {
                    mp_css.remove();
                }, 4500);
            }
        }
    }
    return changeMaster;
}

function handleMenuSelected(currConf, newConf, changeMaster, menuItem) {
    var selectedClass = '';
    var destItem = $('a[onclick*="doTransition(' + newConf.pageOrd + ',"][class*="menucomp"]');
    if (currConf.masterOrd != newConf.masterOrd && !changeMaster) {
        var selector = $('#masterpage_' + newConf.masterOrd).find('a[onclick*="doTransition(' + newConf.pageOrd + ',"][class*="menucomp"]');
        if (selector.length > 0) {
            selectedClass = selector.attr('class').replace('item', 'selected');
        }
        $('a[onclick*="doTransition"][class*="menucomp"]').removeClass(selectedClass);
        $(destItem.addClass(selectedClass));
    } else {
        if ($(menuItem).attr('class') && $(menuItem).attr('class').indexOf('item') > -1) {
            selectedClass = $(menuItem).attr('class').replace('item', 'selected');
            $(menuItem).addClass(selectedClass);

        } else {
            if (destItem.length > 0) {
                selectedClass = destItem.attr('class').replace('item', 'selected');
            }
        }
        var menuItems = $('a[onclick*="doTransition(' + currConf.pageOrd + ',"][class*="menucomp"]');
        for (var x = 0; x < menuItems.length; x++) {
            var sclass;
            if ($(menuItems[x]).attr('class').indexOf('subitem') > -1) {
                sclass = $(menuItems[x]).attr('class').split(' ')[0].replace('subitem', 'selected');
                $(menuItems[x]).removeClass($(menuItems[x]).attr('class').split(' ')[0].replace('subitem', 'subselected'));
            } else {
                sclass = $(menuItems[x]).attr('class').split(' ')[0].replace('item', 'selected');
            }
            $(menuItems[x]).removeClass(sclass);
        }
        for (x = 0; x < destItem.length; x++) {
            if ($(destItem[x]).attr('class').indexOf('subitem') > -1) {
                sclass = $(destItem[x]).attr('class').split(' ')[0].replace('subitem', 'selected');
            } else {
                sclass = $(destItem[x]).attr('class').split(' ')[0].replace('item', 'selected');
            }
            $(destItem[x]).addClass(sclass);
        }

        ///destItem.addClass(selectedClass);
        if ($(menuItem).parents('.accord').length != 0) {
            $(menuItem).parents('nav').children('ul').find('ul[class*="submenu"]').hide();
            $(menuItem).parent().children('ul').show();
            if ($(menuItem).attr('class').indexOf('_subitem') > -1) {
                $(menuItem).parents('ul').show();
            }
        }
    }
   
    destItem.addClass(selectedClass);
    
    
}

function handleBrowserUrlAndPageName(newConf, menuItem,blogUrl) {
    var data = { pageOrd: newConf.pageOrd, href: newConf.title };
    if (menuItem) {
        var title = $(menuItem).attr('href') ? $(menuItem).attr('href') : '/' + newConf.title;
        if (title.indexOf('javascript') > -1) {
            title = newConf.title;
        }
        history.pushState(data, newConf.friendlyTitle, title.indexOf("http") > -1 ? title : (isBlogTransition ? blogUrl : "//" + window.location.host + title));
    }
    var seoTitle = newConf.friendlyTitle;
    if (window.transitions.pages[newConf.pageOrd.split('_')[0]]) {
        seoTitle = window.transitions.pages[newConf.pageOrd.split('_')[0]].seoTitle;
        if (seoTitle.indexOf("[[blog:") == 0) {
            seoTitle = window.transitions.pages[newConf.pageOrd].friendlyTitleCurrent;
        }
        
    }
    if (seoTitle) {
        seoTitle = seoTitle.replace(/&amp;/g, '&');
    }
    $(document).prop('title', seoTitle);
  
    if (window._gaq) {
        _gaq.push(['_trackPageview']);
    }
}

function getUrlForAjax(menuItem, blogUrl, newConf, href) {
    var url;
    if (menuItem) {
        if (isBlogTransition) {
            url = blogUrl;
        } else {
            if ($(menuItem).attr('href') && $(menuItem).attr('href').indexOf('javascript') == -1) {
                url = $(menuItem).attr('href').indexOf("http") > -1 ? $(menuItem).attr('href') : "//" + window.location.host + $(menuItem).attr('href');
            } else {
                url = "//" + window.location.host + '/' + newConf.title;
            }
        }
    } else {
        if (href.indexOf('/') != 0) {
            href = '/' + href;
        }
        url = "//" + window.location.host + href;
    }
    return url;
}


;


﻿var respBPs = null;
$(document).ready(function () {
    if (!respBPs) {
        return;
    }
    $(window).resize(function () {
        var width = $(this).width();
        if (nextHighBP && width > nextHighBP) {
            responsiveBP(respState - 1);
        }
        if (nextLowBP && width < nextLowBP) {
            responsiveBP(respState + 1);
        }
    });
    initResponsive();
    ma_log('width: ' + $(window).width() + ', next low: ' + nextLowBP + ', next high: ' + nextHighBP + ', state: ' + respState);
});

var respState = 0;
//var respBPs = [700, 500];
var nextLowBP, nextHighBP;

function initResponsive() {
    if (respBPs.length == 0) {
        return;
    }
//    respBPs.sort(function (a, b) {
//        return b - a;
    //    });
    setTimeout(function() {
        $('div[id^=columns]').css('min-height', '');
    }, 1000);
    var width = $(window).width();
    if (width > respBPs[0]) {
        respState = 0;
        nextLowBP = respBPs[0];
        return;
    }
    if (width < respBPs[respBPs.length - 1]) {
        respState = respBPs.length;
        nextHighBP = respBPs[respBPs.length - 1];
        return;
    }
    for (var i = 0; i < respBPs.length - 1; i++) {
        var rbp1 = respBPs[i];
        var rbp2 = respBPs[i + 1];
        if (width < rbp1 && width >= rbp2) {
            respState = i + 1;
            nextHighBP = rbp1;
            nextLowBP = rbp2;
        }
    }
}

function responsiveBP(state) {
    $('[respstate=' + respState + ']').hide();
    $('[respstate=' + state + ']').show();
    respState = state;
    nextHighBP = respState == 0 ? null : respBPs[respState - 1];
    nextLowBP = respState == respBPs.length ? null : respBPs[respState];
}


function ma_log(str) {
    if (window.console.debug) {
        window.console.debug(str); // FF
    }
    else if (window.console.log) {
        window.console.log(str); // Chrome
    }
}
;


﻿// https://developer.mozilla.org/en/docs/Web/JavaScript/Reference/Global_Objects/Array/indexOf#Polyfill
if (!Array.prototype.indexOf) {
    Array.prototype.indexOf = function (searchElement, fromIndex) {
        var k;
        if (this == null) {
            throw new TypeError('"this" is null or not defined');
        }
        var O = Object(this);
        var len = O.length >>> 0;
        if (len === 0) {
            return -1;
        }
        var n = +fromIndex || 0;

        if (Math.abs(n) === Infinity) {
            n = 0;
        }
        if (n >= len) {
            return -1;
        }
        k = Math.max(n >= 0 ? n : len - Math.abs(n), 0);
        while (k < len) {
            if (k in O && O[k] === searchElement) {
                return k;
            }
            k++;
        }
        return -1;
    };
}

function initLayout() {
    var $body = $('body');
    var $msg = $('#msgwebcontainer');
    var direction = $body.attr('direction');
    if (direction == 'rtl') {
        $msg.css('direction', 'rtl');
        $body.css('direction', 'ltr');
    }
    switch (camilyo.bgStyle) {
        case 'Vertiacl':
        case 'Centered':
//            $('html').css('height', '100%');
            $('body.msgbody').css({
                'box-sizing': 'border-box',
                '-webkit-box-sizing': 'border-box',
                '-moz-box-sizing': 'border-box',
                '-ms-box-sizing': 'border-box',
                '-o-box-sizing': 'border-box'
            });
            //    $('body.msgbody').css({'box-sizing': 'border-box', padding: '40px 0'});
            $('#msgwebcontainer').css('height', '100%');
            $('body').css('height', '100%');
            break;
        case 'Wide':
            $('html').css('height', '100%');
            $('body.msgbody').css('height', '100%');
//            fixFooterHeight();
            if (camilyo.stickyPanels.indexOf('Footer') != -1) {
                $('html').css('height', '');
            }
            break;
        default:
            break;
    }
    fixLayoutOnWindowResize();
}

function fixFooterHeight() {
    var $footer = $('#FooterExternal');
    if ($footer.length == 0) {
        $footer = $('.FooterExternal_wp_outer').filter(":visible");
    }
    $footer.css('height', '');
    var footerHeight = $footer.outerHeight();
    var footerBottom = $footer.position().top + footerHeight;
    var bodyHeight = $('body.msgbody').outerHeight();
    if (footerBottom < bodyHeight) {
        footerHeight = footerHeight + bodyHeight - footerBottom;
        $footer.css('height', footerHeight);
    }
}

function fixLayoutOnWindowResize() {
    switch (camilyo.bgStyle) {
        case 'Vertical':
        case 'Centered':
            var $body = $('body.msgbody');
            if ($('html').get(0).scrollHeight > $('html').get(0).clientHeight) {
                $body.css('height', '');
            }
            else {
                $body.css('height', '100%');
            }
            break;
        case 'Wide':
            $('html').css('height', '100%');
//            fixFooterHeight();
            if (camilyo.stickyPanels.indexOf('Footer') != -1) {
                $('html').css('height', '');
            }
            break;
        default:
            break;
    }
}


;


﻿var panels;

function initStickyPanels(resetCss) {
    // init params
    var zIndex = 100000;
    var $center = $('[id="' + (camilyo.bgStyle == 'Centered' ? 'Center' : 'Content')+'"]');
    if ($center.length == 0 && camilyo.bgStyle != 'Centered') {
        $center = $('[id$="MainContent"]').filter(":visible");
    }
    var $content = $('[id$="Content"]').filter(":visible");
    if ($content.length == 0) {
        $content = $('[id$="MainContent"]').filter(":visible");
    }
    var sMiddle = camilyo.bgStyle != 'Wide' ? 'Middle' : 'MiddleExternal';
    var $middle = $('[id$="' + sMiddle + '"]').filter(":visible");
    // calculate ALL positions before applying so it will not effect one another
    panels = {};
    var panelCss;
    var $box;
    var changes = [];
    $.each(camilyo.stickyPanels, function (i, key) {
        $box = $('[id$="' + key + '"]').filter(":visible");
        if ($box.length == 0) {
            $box = $('#Master' + key);
        }
        if (resetCss && camilyo.bgStyle == 'Wide' && key != 'Right' && key != 'Left') {
            $box.css('height', '');
            $box.css('position', '');
            $box.css('width', '');
			if (key == 'HeaderExternal' && window.outerWidth > $(window).width() && ($(window).height() + $('.HeaderExternal_wp_outer').outerHeight() - $('#msgwebcontainer').outerHeight()) >= 0) {
			    $('body').css('overflow', 'hidden');
        }
			if (key == 'FooterExternal' && window.outerWidth > $(window).width() && ($(window).height() + $('.FooterExternal_wp_outer').outerHeight() + $('.HeaderExternal_wp_outer').outerHeight() - $('#msgwebcontainer').outerHeight()) >= 0) {
			    $('body').css('overflow', 'hidden');
			}
        }
   
        if ($box.length == 0) return;
        // base position - same for all panels
        panelCss = {
            width: $box.outerWidth(),
            height: camilyo.bgStyle != 'Vertical' || (key!='Left' && key!='Right')?$box.outerHeight():'',
            position: 'fixed',
            'z-index': zIndex
        };
        $('body').css('overflow', '');
        // specific positioning by panel type
        switch (key) {
            case 'Header':
            case 'HeaderExternal':
                panelCss.top = 0;
                if (camilyo.platform == 'MOBILE' || camilyo.platform == 'TABLET') {
                    panelCss.left = 0;
                }
                changes.push({ $el: $middle, style: 'margin-top', value: panelCss.height });
                break;
            case 'Footer':
            case 'FooterExternal':
                panelCss.bottom = 0;
                if (camilyo.platform == 'MOBILE' || camilyo.platform == 'TABLET') {
                    panelCss.left = 0;
                }
                changes.push({ $el: $middle, style: 'margin-bottom', value: panelCss.height });
                break;
            case 'Left':
                if (camilyo.bgStyle != 'Vertical') {
                    panelCss.left = $box.offset().left,
                    panelCss.width = $box.outerWidth();
                    changes.push({ $el: $center, style: 'margin-left', value: panelCss.width });
                } else {
                    panelCss.left = 0;
                    panelCss.top = 0;
                    panelCss["overflow-y"] = 'auto';
                }
                break;
            case 'Right':
                if (camilyo.bgStyle != 'Vertical') {
                    panelCss.left = $box.offset().left,
                    panelCss.width = $box.outerWidth();
                    changes.push({ $el: $center, style: 'margin-right', value: panelCss.width });
                    break;
                } else {
                    panelCss.right = 0;
                    panelCss.top = 0;
                    panelCss["overflow-y"] = 'auto';
                }
                break;
            case 'ContentTop':
                panelCss.top = $('[id$="HeaderExternal"]').filter(":visible").length == 1 ? $('[id$="HeaderExternal"]').filter(":visible").outerHeight() : 0;
                changes.push({ $el: $content, style: 'padding-top', value: panelCss.height });
                break;
            case 'ContentBottom':
                panelCss.bottom = $('[id$="FooterExternal"]').filter(":visible").length == 1 ? $('[id$="FooterExternal"]').filter(":visible").outerHeight() : 0;
                changes.push({ $el: $content, style: 'padding-bottom', value: panelCss.height });
                break;
        }
        // store panel data
        panels[key] = panelCss;
    });
    // if content bottom exists and not sticky - fix main content padding
    fixContentBottom();
    // apply global changes
    for (var i = 0; i < changes.length; i++) {
        var change = changes[i];
        change.$el.css(change.style, change.value);
    }
    // apply positions
    for (var posKey in panels) {
        panelCss = panels[posKey];
        $box = $('[id$="' + posKey + '"]').filter(":visible");
        if ($box.length == 0) {
            $box = $('#Master' + posKey);
        }
        $box.css(panelCss);
    }
    if (bPrintStickyPanelsLog) {
        printStickyPanels();
    }
}

function fixContentBottom() {
    var $content = $('[id$="Content"]').filter(":visible");
    if ($content.length == 0) {
        $content = $('[id$="MainContent"]').filter(":visible");
    }
    var $cb = $('[id$="ContentBottom"]').filter(":visible");
    if ($cb.length == 0) {
        $cb = $('[id$="MasterContentBottom"]').filter(":visible");
    }
    if ($cb.length == 1 && $cb.css("position") != "relative" && camilyo.stickyPanels.indexOf('ContentBottom') == -1) {
        setTimeout(function () {
            $content.css({ 'padding-bottom': $cb.outerHeight() });
        }, 0);
    }
};


function clearStickPanels() {
    for (var posKey in panels) {
        var $box = $('[id$="' + posKey + '"]').filter(":visible");
        if ($box.length == 0) {
            $box = $('#Master' + posKey);
        }
        for (var style in panels[posKey]) {
            $box.css(style, '');			
        }
    }
};

var supportsOrientationChange = "onorientationchange" in window;
var orientationEvent = supportsOrientationChange ? "orientationchange" : "resize";

if (window.addEventListener) {
    window.addEventListener(orientationEvent, function () {
        setTimeout(function () {
            clearStickPanels();
            initStickyPanels();
			if (typeof (window.msgExpand) == 'function') {
                msgExpand();
            }
        }, 300);
    }, false);
}

var bPrintStickyPanelsLog = false;

function printStickyPanels() {
    var $log = $('[name=log]');
    if ($log.length == 0) {
        $log = $('<div name="log" style="position:fixed;bottom:0;width:100%;height:50%;overflow:auto;direction:ltr;background-color:white;color:black;text-align:left;"></div>');
        $log.appendTo('body');
    }
    var posHtml = '';
    var domHtml = '';
    for (var posKey in panels) {
        posHtml += posKey + ': ';
        for (var style in panels[posKey]) {
            posHtml += style + ':' + panels[posKey][style] + ';';
        }
        posHtml += '<br></br>'
        var $box = $('#Master' + posKey);
        domHtml += 'width:' + $box.outerWidth() + ';height:' + $box.outerHeight() + ';top:' + $box.offset().top + ';left:' + $box.position().left;
        domHtml += '<br></br>'
    }
    $log.append('Calculated Pos:<br></br>');
    $log.append(posHtml)
    $log.append('<br></br>Dom Pos:<br></br>');
    $log.append(domHtml)
}

;


